function [dx]=ode_tau(t,x,params)

vp=params.vp;
ve=params.ve;
we=params.we;
%rho=params.rho;
thetF=params.thetF;

ue=params.ue;


x1=x(1);
x2=x(2);

hypo=sqrt(x1^2+x2^2);
thet=asin(x1/hypo);

up=pi+thet;


dx1=-(-we*x2*ue+vp*sin(up));
dx2=-(we*x1*ue-ve+vp*cos(up));

dx=[dx1;
    dx2];

end