clc
close all
clear


FT=18;


N=6; 
Ci=1;

C = linspecer(N);
ci=1;

max_Tvalue=0;

% Definition of parameters:
vp=1;

ve=1.5;
we=1; y_limit=0.87;
% we=2; y_limit=0.42;

% ve=2;
% we=1; y_limit=0;
% we=2; y_limit=0;

% we=3;



rho=1;
thetF=-pi;

ue=-1;
y_limit=0;


params.vp=vp;
params.ve=ve;
params.we=we;
params.rho=rho;
params.thetF=thetF;
params.ue=ue;

tt=linspace(0,2*pi,501);
xx=rho*sin(tt);
yy=rho*cos(tt);

thet_max=acos(-vp/ve);

ttUS=linspace(thet_max,pi,101);
xxUS=rho*sin(ttUS);
yyUS=rho*cos(ttUS);

xmax=rho*sin(thet_max);
ymax=rho*cos(thet_max);

h1=figure(1);
plot(xx,yy,'linewidth',2,'color',C(ci,:))
hold on; grid on; box on;
ci=ci+1;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PLOT USABLE PART SOLUTIONS

thetT1=linspace(0+eps,pi,551);


opts = odeset('RelTol',1e-12,'AbsTol',1e-12);    


ue=-1;
params.ue=ue;
for k=1:length(thetT1)

    thetF=thetT1(k);
    params.thetF=thetF;

    x0=[rho*sin(thetF);
        rho*cos(thetF)];

%     tspan=[0,1.5];
    tspan=[0,5];
    
    

    [t,x]=ode45(@(t,x)ode_tau(t,x,params),tspan,x0,opts);

        for i=1:length(t)
            
            if norm(x(i,:))>rho || x(i,1)<0
                x(i,:) = [nan nan];
                t(i)=nan;
            end
        end
    figure(1)
    scatter3(x(:,1),x(:,2),t,5,t,'.')%,'linewidth',2,'color',C(ci,:))   
%    plot3(x(:,1),x(:,2),t,'linewidth',2,'color',C(ci,:))   
    
    if max(t)>max_Tvalue
        max_Tvalue=max(t);
    end
end

ue=1;
params.ue=ue;
for k=1:length(thetT1)

    thetF=-thetT1(k);
    params.thetF=thetF;

    x0=[rho*sin(thetF);
        rho*cos(thetF)];

    tspan=[0,1.5];
    tspan=[0,5];
    
    

    [t,x]=ode45(@(t,x)ode_tau(t,x,params),tspan,x0,opts);

        for i=1:length(t)
            
            if norm(x(i,:))>rho || x(i,1)>0
                x(i,:) = [nan nan];
                t(i)=nan;
            end
        end
    figure(1)
    scatter3(x(:,1),x(:,2),t,5,t,'.')%,'linewidth',2,'color',C(ci,:))   
%     plot3(x(:,1),x(:,2),t,'linewidth',2,'color',C(ci,:))   
    if max(t)>max_Tvalue
        max_Tvalue=max(t);
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Plot Y-AXIS, Y<0
ci=ci+1;

YY=linspace(-params.rho,-0.001,551);

ue=-1;
params.ue=ue;
for k=1:length(YY)

    x0=[0;
        YY(k)];

    tspan=[0,2];

    [t,x]=ode45(@(t,x)ode_tau_away_from_y_axis(t,x,params),tspan,x0,opts);
    for i=1:length(t)            
        if norm(x(i,:))>rho || x(i,1)<0
            x(i,:) = [nan nan];
            t(i)=nan;
        end
    end

    figure(1)
    scatter3(x(:,1),x(:,2),t+(rho+YY(k))/(ve-vp),5,t+(rho+YY(k))/(ve-vp),'.')
    if max(t+(rho+YY(k))/(ve-vp))>max_Tvalue
        max_Tvalue=max(t+(rho+YY(k))/(ve-vp));
    end
    
end

ue=1;
params.ue=ue;
for k=1:length(YY)

    x0=[0;
        YY(k)];

    tspan=[0,2];

    [t,x]=ode45(@(t,x)ode_tau_away_from_y_axis(t,x,params),tspan,x0,opts);
    for i=1:length(t)            
        if norm(x(i,:))>rho || x(i,1)>0
            x(i,:) = [nan nan];
            t(i)=nan;
        end
    end

    figure(1)
    scatter3(x(:,1),x(:,2),t+(rho+YY(k))/(ve-vp),5,t+(rho+YY(k))/(ve-vp),'.')
    if max(t+(rho+YY(k))/(ve-vp))>max_Tvalue
        max_Tvalue=max(t+(rho+YY(k))/(ve-vp));
    end
    
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ci=ci+1;
%%% PLOT Y-AXIS

ue=0;
params.ue=ue;

thetF=thet_max;
params.thetF=thet_max-0.1;

x0=[0;
    -params.rho];

tspan=0:0.1:1.5*rho/(ve-vp);
x2=linspace(-rho,y_limit,100);
x1=0*x2;

figure(1)



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% FINALIZE PLOT
ci=ci+1;

colorbar
% colormap autumn(15)
colormap autumn
clim([0 4])
plot(xxUS,yyUS,'color',C(ci,:),'linewidth',2)
plot(-xxUS,yyUS,'color',C(ci,:),'linewidth',2)
axis equal
xlabel('$x$','fontsize',FT,'interpreter','latex')
ylabel('$y$','fontsize',FT,'interpreter','latex')
zlabel('$V(\xi)$','fontsize',FT,'interpreter','latex')
set(gca,'Fontsize',FT);

%view([-5 -3 2])

if ve == 1.5
    if we == 1
        clim([0 3.75])
        saveas(h1,'3d_full_solution_15_1','epsc')
%         view([-15 -3 2])
%         saveas(h1,'2_3d_full_solution_15_1','epsc')
    elseif we==2
        clim([0 3])
        saveas(h1,'3d_full_solution_15_2','epsc')
%         view([-15 -3 2])
%         saveas(h1,'2_3d_full_solution_15_2','epsc')
    end
elseif ve==2
    if we == 1
        clim([0 1.9])
        saveas(h1,'3d_full_solution_2_1','epsc')
%         view([-15 -3 2])
%         saveas(h1,'2_3d_full_solution_2_1','epsc')
    elseif we==2
        clim([0 1.6])
        saveas(h1,'3d_full_solution_2_2','epsc')
%         view([-15 -3 2])
%         saveas(h1,'2_3d_full_solution_2_2','epsc')
    end
end
    

max_Tvalue







