clc
close all
clear


FT=18;


N=6; 
Ci=1;

C = linspecer(N);
ci=1;

% Definition of parameters:
vp=1;

ve=1.5;
we=1; y_limit=0.2;
we=2; y_limit=0.1;



% we=3;

rho=1;
thetF=-pi;

ue=-1;

params.vp=vp;
params.ve=ve;
params.we=we;
params.rho=rho;
params.thetF=thetF;
params.ue=ue;

tt=linspace(0,2*pi,501);
xx=rho*sin(tt);
yy=rho*cos(tt);

thet_max=acos(-vp/ve);

ttUS=linspace(thet_max,pi,101);
xxUS=rho*sin(ttUS);
yyUS=rho*cos(ttUS);

xmax=rho*sin(thet_max);
ymax=rho*cos(thet_max);

h1=figure(1);
plot(xx,yy,'linewidth',2,'color',C(ci,:))
hold on; grid on; box on;
ci=ci+1;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PLOT USABLE PART SOLUTIONS

thetT1=linspace(thet_max+eps,pi,6);


opts = odeset('RelTol',1e-12,'AbsTol',1e-12);    




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Plot Y-AXIS, Y<0
ci=ci+1;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Plot Y-AXIS, Y>0
ci=ci+1;

YY=linspace(0,y_limit,6);

ue=-1;
params.ue=ue;
for k=1:length(YY)

    x0=[0;
        YY(k)];

    tspan=[0,2];

    [t,x]=ode45(@(t,x)ode_tau_away_from_y_axis(t,x,params),tspan,x0,opts);
    for i=1:length(t)            
        if norm(x(i,:))>rho %|| x(i,1)<0
            x(i,:) = [inf inf];
        end
    end

    figure(1)
    if k==1
        plot(x(:,1),x(:,2),'color',C(ci,:),'linewidth',1,'linestyle','-')
    else
        plot(x(:,1),x(:,2),'color',C(ci,:),'linewidth',1)
    end
    
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ci=ci+1;
%%% PLOT Y-AXIS




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% FINALIZE PLOT
ci=ci+1;

plot(xxUS,yyUS,'color',C(ci,:),'linewidth',2)
plot(-xxUS,yyUS,'color',C(ci,:),'linewidth',2)
axis equal
xlabel('$x$','fontsize',FT,'interpreter','latex')
ylabel('$y$','fontsize',FT,'interpreter','latex')
set(gca,'Fontsize',FT);

xlim([-0.3 0.3])
ylim([0 1])

if we == 1
    saveas(h1,'new_game2w_solution_15_1','epsc')
elseif we==2
    saveas(h1,'new_game2w_solution_15_2','epsc')
end

    







