clc
close all
clear


FT=18;


N=6; 
Ci=1;

C = linspecer(N);
ci=1;

% Definition of parameters:
vp=0;

ve=1;
we=1; y_limit=0;

rho=1;
thetF=-pi;

ue=-1;

params.vp=vp;
params.ve=ve;
params.we=we;
params.rho=rho;
params.thetF=thetF;
params.ue=ue;

tt=linspace(0,2*pi,501);
xx=rho*sin(tt);
yy=rho*cos(tt);

thet_max=acos(-vp/ve);

ttUS=linspace(thet_max,pi,101);
xxUS=rho*sin(ttUS);
yyUS=rho*cos(ttUS);

xmax=rho*sin(thet_max);
ymax=rho*cos(thet_max);

h1=figure(1);
plot(xx,yy,'linewidth',2,'color',C(ci,:))
hold on; grid on; box on;
ci=ci+1;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PLOT USABLE PART SOLUTIONS

thetT1=linspace(thet_max+eps,pi,11);


opts = odeset('RelTol',1e-12,'AbsTol',1e-12);    


ue=-1;
params.ue=ue;
for k=1:length(thetT1)

    thetF=thetT1(k);
    params.thetF=thetF;

    x0=[rho*sin(thetF);
        rho*cos(thetF)];

%     tspan=[0,1.5];
    tspan=[0,5];
    
    

    [t,x]=ode45(@(t,x)ode_tau(t,x,params),tspan,x0,opts);

        for i=1:length(t)
            
            if norm(x(i,:))>rho || x(i,1)<0
                x(i,:) = [inf inf];
            end
        end
    figure(1)
    plot(x(:,1),x(:,2),'linewidth',2,'color',C(ci,:))   
end

ue=1;
params.ue=ue;
for k=1:length(thetT1)

    thetF=-thetT1(k);
    params.thetF=thetF;

    x0=[rho*sin(thetF);
        rho*cos(thetF)];

    tspan=[0,1.5];
    tspan=[0,5];
    
    

    [t,x]=ode45(@(t,x)ode_tau(t,x,params),tspan,x0,opts);

        for i=1:length(t)
            
            if norm(x(i,:))>rho || x(i,1)>0
                x(i,:) = [inf inf];
            end
        end
    figure(1)
    plot(x(:,1),x(:,2),'linewidth',2,'color',C(ci,:))    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Plot Y-AXIS, Y<0
ci=ci+1;

YY=linspace(-params.rho,-0.001,9);

ue=-1;
params.ue=ue;
for k=1:length(YY)

    x0=[0;
        YY(k)];

    tspan=[0,2];

    [t,x]=ode45(@(t,x)ode_tau_away_from_y_axis(t,x,params),tspan,x0,opts);
    for i=1:length(t)            
        if norm(x(i,:))>rho || x(i,1)<0
            x(i,:) = [inf inf];
        end
    end

    figure(1)
    if k==1
        plot(x(:,1),x(:,2),'color',C(ci,:),'linewidth',2,'linestyle','--')
    else
        plot(x(:,1),x(:,2),'color',C(ci,:),'linewidth',2)
    end
    
end

ue=1;
params.ue=ue;
for k=1:length(YY)

    x0=[0;
        YY(k)];

    tspan=[0,2];

    [t,x]=ode45(@(t,x)ode_tau_away_from_y_axis(t,x,params),tspan,x0,opts);
    for i=1:length(t)            
        if norm(x(i,:))>rho || x(i,1)>0
            x(i,:) = [inf inf];
        end
    end

    figure(1)
    if k==1
        plot(x(:,1),x(:,2),'color',C(ci,:),'linewidth',2,'linestyle','--')
    else
        plot(x(:,1),x(:,2),'color',C(ci,:),'linewidth',2)
    end
    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Plot Y-AXIS, Y>0
ci=ci+1;


YY=linspace(0,rho,21);

ue=-1;
params.ue=ue;
for k=1:length(YY)

    x0=[0;
        YY(k)];

    tspan=[0,2];

    [t,x]=ode45(@(t,x)ode_tau_away_from_y_axis(t,x,params),tspan,x0,opts);
    for i=1:length(t)            
        if norm(x(i,:))>rho || x(i,1)<0
            x(i,:) = [inf inf];
        end
    end

    figure(1)
    if k==1
        plot(x(:,1),x(:,2),'color',C(ci,:),'linewidth',2,'linestyle','--')
    else
        plot(x(:,1),x(:,2),'color',C(ci,:),'linewidth',2)
    end
    
end

ue=1;
params.ue=ue;
for k=1:length(YY)

    x0=[0;
        YY(k)];

    tspan=[0,2];

    [t,x]=ode45(@(t,x)ode_tau_away_from_y_axis(t,x,params),tspan,x0,opts);
    for i=1:length(t)            
        if norm(x(i,:))>rho || x(i,1)>0
            x(i,:) = [inf inf];
        end
    end

    figure(1)
    if k==1
        plot(x(:,1),x(:,2),'color',C(ci,:),'linewidth',2,'linestyle','--')
    else
        plot(x(:,1),x(:,2),'color',C(ci,:),'linewidth',2)
    end
    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ci=ci+1;
%%% PLOT Y-AXIS

ue=0;
params.ue=ue;

thetF=thet_max;
params.thetF=thet_max-0.1;

x0=[0;
    -params.rho];

tspan=0:0.1:1.5*rho/(ve-vp);
x2=linspace(-rho,y_limit,100);
x1=0*x2;

figure(1)
%     plot(x(:,1),x(:,2),'r')
plot(x1,x2,'color',C(ci,:),'linewidth',2)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% FINALIZE PLOT
ci=ci+1;

plot(xxUS,yyUS,'color',C(ci,:),'linewidth',2)
plot(-xxUS,yyUS,'color',C(ci,:),'linewidth',2)
axis equal
xlabel('$x$','fontsize',FT,'interpreter','latex')
ylabel('$y$','fontsize',FT,'interpreter','latex')
set(gca,'Fontsize',FT);

saveas(h1,'full_solution_stationary','epsc')

        
        
    







